#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// deep insideMod01.fsh by  Del
//https://www.shadertoy.com/view/Xs3yWN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Bloody Tunnel - Del - 16/02/2018 (modified water shader from somewhere on shadertoy)

#define EULER 2.7182818284590452353602874
#define IEULER 0.367879
// its from here https://github.com/achlubek/venginenative/blob/master/shaders/include/WaterHeight.glsl 
float wave(vec2 uv, vec2 emitter, float speed, float phase, float timeshift)
{
	float dst = distance(uv, emitter);
    float time = iTime*0.1;
	return pow(EULER, sin(dst * phase - (time + timeshift) * speed));
}
vec2 wavedrag(vec2 uv, vec2 emitter)
{
	return normalize(uv - emitter);
}

// Same, but mirror every second cell so they match at the boundaries
float pModMirror1(inout float p, float size)
{
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize,size) - halfsize;
	p *= mod(c, 2.0)*2.0 - 1.0;
	return c;
}

float getwaves(vec2 position,float mirrorX,float mirrorY)
{
    float iter = 0.0;
    float phase = 6.0;
    float speed = 2.0;
    float weight = 1.2;
    float w = 0.0;
    float ws = 0.0;
    float iwaterspeed = 1.0;
    
    pModMirror1(position.x,mirrorX);
    pModMirror1(position.y,mirrorY);
    for(int i=0;i<20;i++)										// crank this for more veins
    {
        vec2 p = vec2(sin(iter), cos(iter)) * 300.0;
        float res = wave(position, p, speed, phase, 0.0) * IEULER;
        float res2 = wave(position, p, speed, phase, 0.006) * IEULER;
        position -= wavedrag(position, p) * (res - res2) * weight * 5.0 * iwaterspeed;
        w += res * weight;
        iter += 12.0;
        ws += weight;
        weight = mix(weight, 0.0, 0.12);
        phase *= 1.2;
        speed = pow(speed, 1.014);
    }
    return w / ws;
}



vec3 tunnel(vec2 p)
{
    float _d = length(p);
    p.x += sin(p.x);
    float wibble = 1.0-(0.1+sin(iTime+_d*_d*15.0)*0.1);
    p.x *= wibble;
    float offx = 0.1+sin(iTime*0.5)*0.05;
    float offy = 0.1+cos(iTime*0.5)*0.1;
    p.x += offx;
    p.y += 0.1-offy;
    
    float a = atan(p.y,p.x);
    float r = length(p);
    vec2 uv = vec2( 0.13/r + 0.125*iTime, a/3.1415927 );
    float w = getwaves(uv,128.0,1.0);
    vec3 col = vec3( 1.0 - w*vec3(.88-w*.15,1.6,1.8)*1.0 );
    col = clamp(col,0.0,1.0);
    r = smoothstep(0.0,0.064,r);
    col = mix(vec3(0.55,0.1,0.05),col,r*r);
    return col;
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = ( fragCoord - 0.5* iResolution.xy ) / iResolution.y;
    vec3 col = tunnel(uv*0.4);
    
    
    // vignette
    float rf = sqrt(dot(uv, uv)) * 0.666;
    float rf2_1 = rf * rf + 1.0;
    col *= 1.0 / (rf2_1 * rf2_1);
    
    
    fragColor = vec4(col.xyz,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

